import React, {Component} from 'react';
import PropTypes from 'prop-types';
import ReactTable from "react-table";
import Loading from "../../../../core/Loading";
import './HabitatsList.css';
import {ButtonGroup, ButtonToolbar, Modal, ModalBody, ModalHeader} from "reactstrap";
import Ionicon from 'react-ionicons'
import {NavLink} from "react-router-dom";
import DeleteButton from "../../../../core/DeleteButton";
import moment from 'moment';
import 'moment/locale/it';
import AcquaticaDrop from "../../../../core/AcquaticaDrop";
import {NotificationManager} from 'react-notifications';
import MonitoraggioSpecieFilters from "./components/MonitoraggioSpecieFilters";
import Permissions from "../../../../permissions";

export default class HabitatList extends Component {

  constructor(props) {
    super(props)

    this.state = {
      filter: '',
      paginationLimit: 50,
      paginationOffset: 1,
      columns: [
        {
          Header: "ID",
          accessor: "id",
          filterable: false,
          sortable: false,
          width: 50,
        },
	 {
          Header: "Val.",
          accessor: "validato",
          filterable: false,
          sortable: false,
          width: 40,
          Cell: (row) => {
            return(
              <div>
                <span
                  style={{
                    color: !row.value ? '#ffbf00' : '#57d500',
                    transition: 'all .3s ease'
                  }}>
                  &#x25cf;
                </span>{' '}
                {row.value ? 'SI': "NO"}
              </div>
            );
          }
        },
        {
          Header: "N. Scheda",
          accessor: "idScheda",
          filterable: false,
          sortable: false,
	  width:125,
        },
        {
          Header: "Specie",
          accessor: "specie",
          filterable: false,
          sortable: false,
	  width: 60,
	  Cell: (row) => { return (
		  <div style={{textAlign:'center'}}><img style={{width:'32px',height:'32px'}} src={'/LifeEremitaWeb/specie/'+row.value.id+'.png'} alt={row.value.denominazioneTaxon} title={row.value.denominazioneTaxon} /></div>
	  )
        }
	},
	 {
          Header: "Data rilievo",
          accessor: "inizioRilievo",
          filterable: false,
          sortable: false,
          width: 100,
          Cell: (row) => {
            return(<div>{moment(row.value).format("L")}</div>);
          }
        },
	 {
          Header: "Sito Natura 2000",
          accessor: "sitoNatura2000",
          filterable: false,
          sortable: false,
	  width:150,
          Cell: (row) => {
            return(<div>{row.value && row.value.id}</div>);
          }
        },
		{
          Header: "Rilevatori",
          accessor: "rilevatori",
          filterable: false,
          sortable: false,
        },

	{
          Header: "Transetto",
          accessor: "transetto",
          filterable: false,
          sortable: false,
        },
        {
          Header: "",
          sortable: false,
          filterable: false,
          accessor: "id",
          Cell: (row) => this.renderCell(row)
        },
      ]
    }

    this.renderCell = this.renderCell.bind(this);
    this.onFetchData = this.onFetchData.bind(this);
    this.onDeleteItem = this.onDeleteItem.bind(this);
    this.onFilterChange = this.onFilterChange.bind(this);
    this.getTotalPages = this.getTotalPages.bind(this);
  }

  componentWillMount() {
    moment.locale("it")
  }

  renderCell(row) {
    const {
      utenteSessione,
      match
    } = this.props

    return(
      <div style={{display: 'flex', alignItems: 'center'}}>
        <div className="btn-group btn-group-sm" style={{margin: '0 auto'}}>
            {/*TODO: rimuovere questi commenti, problemi loro come da email */}

          <NavLink className="btn ionicon-btn btn-light" to={match.url + "/" + row.value}>
            <Ionicon icon="ios-search-outline"/>
          </NavLink>
        {!utenteSessione.loading && ((!!row.original.utenteCreazione &&
        (utenteSessione.utenteSessione.id == row.original.utenteCreazione.id &&
            utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.writeOwnMonitHabitat).length>0)) ||
            utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.writeMonitHabitat).length>0) &&
	    <div className="btn-group btn-group-sm" style={{display:'flex',margin:'0 auto'}}>
            	<NavLink className="btn ionicon-btn btn-light" to={match.url + "/" + row.value + "/edit"}>
               		 <Ionicon icon="ios-create-outline"/>
           	 </NavLink>
		<DeleteButton id={"delete-" + row.value} size={"sm"} onDelete={() => this.onDeleteItem(row.value)}>
           	    <Ionicon icon="ios-trash-outline" color="#ffffff" />
          	</DeleteButton>
	    </div>
        }
          
        </div>
      </div>
    )
  }

  onDeleteItem(id) {
    this.props.mutate({ variables: {id: id} }).then(data => {
      this.props.data.refetch()
    }).catch(err => {
      NotificationManager.error("Errore durante l'eliminazione del Monitoraggio Habitat");
    })
  }

  onFetchData(state, instance) {
    this.props.data.refetch({
      pagination: {
        limit: state.pageSize,
        offset: state.page * state.pageSize,
      },
      filtro: this.state.filter,
      //sort: sortObj,
    })
    this.setState({
      paginationLimit: state.pageSize,
      paginationOffset: state.page * state.pageSize
    })
  }

  onFilterChange(filter) {
    this.setState({filter: filter})

    this.props.data.refetch({
      pagination: {
        limit: this.state.paginationLimit,
        offset: this.state.paginationOffset
      },
      filtro: filter,
      //sort: sortObj,
    })
  }

  getTotalPages () {
    if (this.props.data.countMonitoraggioHabitat2 > 0) {
      return Math.ceil(this.props.data.countMonitoraggioHabitat2 / this.state.paginationLimit)
    }

    return 0
  }

  render() {
    const {
      data,
      match,
      utenteSessione
    } = this.props

    const {
      columns,
      pages,
    } = this.state

    if(data.error) {
      return(<div className="text-danger">
        Errore nella ricezione dei dati
      </div>)
    }

    /*if(data.loading) {
        return <Loading/>;
    }*/

    return(
      <div className="container-fluid">
        <div className="btn-toolbar" style={{backgroundColor: '#fff'}}>
          <div className="btn-group mr-2 ml-auto">
            {!utenteSessione.loading &&
            !!utenteSessione.utenteSessione.ruolo.permessi.filter(item => item.id == Permissions.insertMonitHabitat).length>0 &&
              <NavLink className="btn ionicon-btn btn-light" to={match.url + "/create"}>
                  <Ionicon icon="ios-add" style={{marginRight: '5px', marginLeft: '-8px'}}/>
                  Nuova Scheda
              </NavLink>
            }
            <button className="btn ionicon-btn btn-light" onClick={() => window.open('/LifeEremitaWeb/csv/monitoraggiHabitat/'+(this.state.filter || '*')+'/monhabitat.csv')} type="button">
              <Ionicon icon="ios-exit-outline" style={{marginRight: '5px', marginLeft: '-8px'}} />
              Esporta CSV
            </button>
          </div>
        </div>

        <MonitoraggioSpecieFilters
          onFilterChange={this.onFilterChange} />

        <ReactTable
          manual
          filterable
          loading={data.loading}
          noDataText={"Nessun monitoraggio habitat presente"}
          onFetchData={this.onFetchData}
          pages={this.getTotalPages()}
          className="-highlight"
          data={data.monitoraggioHabitat2}
          style={{}}
          defaultPageSize={10}
          nextText="Avanti"
          previousText="Indietro"
          loadingText="Caricamento in corso..."
          rowsText="elementi"
          ofText="di"
          pageText="Pagina"
          columns={columns} />
      </div>
    )
  }
}

HabitatList.defaultProps = {}

HabitatList.propTypes = {

}
